<?php
/*     
    PanaChart - PHP Chart Generator -  October 2003    
    
    Copyright (C) 2003 Eugen Fernea - eugenf@panacode.com
    Panacode Software - info@panacode.com
    http://www.panacode.com/
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation;
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.    
*/  
    include_once("./panachart.php");
    
    $k=0;
    $vCht2 = array(22,31,46,37,24,33,40,55,49,63,32,35,52,35,22,93,32,43,42,54,22,54,33,29);
    $vCht3 = array(22,31,46,37,24,33,40,55,49,63,32,35,55,49,63);

    $vCht12 = array(2,3,5,7,4,9,6,8,4,7,5,8,3,5,5,9,2,4,1,9,3,8,7,9);
    $vCht10 = array(1,6,9,2,3,10,4,9,3,9,3,8,1,6,3,9,1,7,0,10,2,10,5,10);

    $vCht4 = array(60,40,20,34,26,52,41,20,34,43,64,40);
    $vCht5 = array(12,21,12,27,14,23,21,5,29,23,12,29);
    $vCht6 = array(5,7,3,15,7,8,2,2,2,11,22,3);    

    $vLabels = array('Jan','Feb','Mar','Apr','May','Jun','Jul'
    ,'Aug','Sep','Oct','Nov','Dec');
        
    //$ochart->setXAxis('#000000', SOLID, 4, "X Axis", '%s');
    //$ochart->setYAxis('#000000', SOLID, 2, "January", '%.3f');
    //$ochart->setLimits(0,70,10);

    // AREA
    $iTime = microtime();
    $ochart = new chart(300,200,7, '#eeeeee');
    $ochart->setTitle("Area & Spline","#000000",2);
    $ochart->setPlotArea(SOLID,"#000000", '#ddddee');
    //$ochart->setLimits(0,70,10);
    $ochart->setLegend(SOLID, "#444444", "#ffffff", 1, '');
    $ochart->addSeries($vCht4,'spline','Series 1', SOLID,'#000000', '#8888ff');
    $ochart->addSeries($vCht5,'area','Series 2', SOLID,'#000000', '#88ff88');
    $ochart->addSeries($vCht6,'area','Series 3', SOLID,'#000000', '#ff8888');
    $ochart->setXAxis('#000000', SOLID, 1, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, HORIZONTAL);
    $ochart->setGrid("#bbbbbb", DOTTED, "#bbbbbb", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;
    
    // AREAS LINES
    $iTime = microtime(); $k++;
    $ochart = new chart(300,200,7, '#cccccc');
    $ochart->setTitle("Area & line","#000000",2);
    $ochart->setPlotArea(SOLID,"#000000", '#ddeedd');
    //$ochart->setLimits(0,70,10);
    $ochart->setLegend(SOLID, "#444444", "#ffffff", 1, '');
    $ochart->addSeries($vCht5,'area','Series1', SOLID,'#000000', '#ffffaa');
    $ochart->addSeries($vCht6,'area','Series2', SOLID,'#000000', '#ffaaaa');
    $ochart->addSeries($vCht4,'line','Series3', DASHED,'#000000', '#0000ff', '%d');
    //$ochart->addSeries($vCht4,'dot','Series4', SOLID,'#000000', '#0000ff');
    $ochart->setXAxis('#000000', MEDIUM_SOLID, 1, "", '%s');
    $ochart->setYAxis('#000000', MEDIUM_SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, HORIZONTAL);
    $ochart->setGrid("#bbbbbb", DOTTED, "#bbbbbb", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;
    
    // BAR
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,7, '#eeeeee');
    $ochart->setTitle("Bar plot","#000000",2);
    $ochart->setPlotArea(SOLID,"#aaaaaa", '#ffffff');
    //$ochart->setLimits(0,30,10);
    $ochart->addSeries($vCht5,'bar','Series1', SOLID,'#444444', '#aa4444');
    $ochart->setXAxis('#000000', SOLID, 1, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, HORIZONTAL);
    $ochart->setGrid("#cccccc", DASHED, "", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;
    
    // MULTIPLE BAR
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,7, '#ccdddd');
    $ochart->setTitle("Multiple bar plot","#000000",2);
    $ochart->setPlotArea(SOLID,"#aaaaaa", '#eeffff');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'bar','Series1', SOLID,'#444444', '#4444dd');
    $ochart->addSeries($vCht5,'bar','Series2', SOLID,'#444444', '#cc4444');
    $ochart->addSeries($vCht6,'bar','Series3', SOLID,'#444444', '#44dd44');
    $ochart->setXAxis('#000000', SOLID, 1, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, HORIZONTAL);
    $ochart->setGrid("#cccccc", SOLID, "", DOTTED);
    $ochart->plot("./shots/$k.png");        
    $vTime[$k] = microtime() - $iTime;

    // BAR LINE
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,7, '#000088');
    $ochart->setTitle("Bar & line","#ffffff",3);
    $ochart->setPlotArea(SOLID,"", '#000088');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht5,'bar','Series1', SOLID,'#000000', '#bbbb00');
    $ochart->addSeries($vCht4,'line','Series2', LARGE_SOLID,'#ffffff', '#bbbb00');
    $ochart->setXAxis('#ffffff', SOLID, 1, "", '%s');
    $ochart->setYAxis('#ffffff', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#ffffff', 1, HORIZONTAL);
    $ochart->setGrid("#7777bb", SOLID, "7777bb", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;

    // STEP & DOT
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,7, '#eeeeee');
    $ochart->setTitle("Step & dot","#444444",3);
    $ochart->setPlotArea(SOLID,"444444", '#bbeeff');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'step','Series1', SOLID,'#000000', '#99ccff');
    $ochart->addSeries($vCht4,'dot','Series2', SOLID,'#0000ff', '#ffffff');
    $ochart->addSeries($vCht5,'step','Series3', DASHED,'#000000', '#66aadd');    
    $ochart->setXAxis('#444444', MEDIUM_SOLID, 1, "", '%s');
    $ochart->setYAxis('#444444', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#444444', 1, HORIZONTAL);
    $ochart->setGrid("#7777bb", DOTTED, "#7777bb", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;
    
    // SPLINE
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,5, '#eeeeee');
    $ochart->setTitle("Natural Cubic Plot","#000000",2);
    $ochart->setPlotArea(SOLID,"#444444", '#dddddd');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'spline','Series1', SOLID,'#00773c', '#ff0000', '%.1f');            
    $ochart->setXAxis('#000000', SOLID, 2, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 2, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, VERTICAL);
    $ochart->setGrid("#bbbbbb", DASHED, "#bbbbbb", DOTTED);    
    $ochart->setLabels($vLabels, '#000000',1, 0);
    $ochart->plot("./shots/$k.png");
    $vTime[$k] = microtime() - $iTime;
    
    // Bubbles
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,5, '#ffffdd');
    $ochart->setTitle("Bubbles","#000000",2);
    $ochart->setPlotArea(SOLID,"#444444", '#eeeedd');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht2,'bubble','Series1', SOLID,'#226600', '#8cef6c');            
    //$ochart->addSeries($vCht4,'dot','Series2', SOLID,'#00aa00', '#ccffcc');
    $ochart->setXAxis('#000000', SOLID, 1, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "Y axis", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, VERTICAL);
    $ochart->setGrid("#bbbbbb", 0, "", DOTTED);
    $ochart->plot("./shots/$k.png");
    $vTime[$k] = microtime() - $iTime;
    
    // FLOATBAR & ERROR
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,5, '#ffdddd');
    $ochart->setTitle("Floatbar & Error","#000000",2);
    $ochart->setPlotArea(SOLID,"#444444", '#ddeeee');
    //$ochart->setLimits(-1,10,1);
    $ochart->addSeries($vCht10,'error','Series2', SOLID,'#000000', '#000000', "%d");
    $ochart->addSeries($vCht12,'floatbar','Series1', SOLID,'#000055', '#ccccff');
    $ochart->setXAxis('#000000', SOLID, 2, "", '%s');
    $ochart->setYAxis('#000000', SOLID, 2, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, VERTICAL);
    $ochart->setGrid("#bbbbbb", DASHED, "#bbbbbb", DOTTED);    
    $ochart->setLabels($vLabels, '#000000',1, 0);
    $ochart->plot("./shots/$k.png");
    $vTime[$k] = microtime() - $iTime;
    
    // BAR & MOVING AVG
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,5, '#eeeeee');
    $ochart->setTitle("Bars & Moving Average","#000000",2);
    $ochart->setPlotArea(SOLID,"#444444", '#dddddd');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'bar','Series1', SOLID,'#000000', '#eeceff');
    $ochart->addSeries($vCht4,'mavg','Series1', SOLID,'#0000ff', '#ff0000');
    $ochart->setXAxis('#000000', SOLID, 1, "X Axis", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, VERTICAL);
    $ochart->setGrid("#bbbbbb", DASHED, "#bbbbbb", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;

    // IMPULS & DOTS
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,5, '#eeeeee');
    $ochart->setTitle("Impuls & dots plot","#0000ff",2);
    $ochart->setPlotArea(SOLID,"#444444", '#dddddd');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'impuls','Series1', SOLID,'#000000', '#0000ff');
    $ochart->addSeries($vCht4,'dot','Series2', SOLID,'#000000', '#0000ff');
    $ochart->setXAxis('#000000', SOLID, 1, "X Axis", '%s');
    $ochart->setYAxis('#000000', SOLID, 1, "", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, VERTICAL);
    $ochart->setGrid("#bbbbbb", DOTTED, "", DOTTED);
    $ochart->plot("./shots/$k.png");    
    $vTime[$k] = microtime() - $iTime;
    
    // IMPULS LINE & DOTS
    $iTime = microtime(); $k++;
    $ochart = new chart(300,130,7, '#bbeebb');
    $ochart->setTitle("Impuls, line & dot","#004400",2);
    $ochart->setPlotArea(SOLID,"#888888", '#bbbbbb');
    //$ochart->setLimits(0,70,10);
    $ochart->addSeries($vCht4,'impuls','Series1', SOLID,'#000000', '#ffff00');
    $ochart->addSeries($vCht4,'line','Series2', SOLID,'#ff0000', '#ffff00');
    $ochart->addSeries($vCht4,'dot','Series3', SOLID,'#ff0000', '#ffff00');
    $ochart->setXAxis('#006600', MEDIUM_SOLID, 1, "", '%s');
    $ochart->setYAxis('#006600', SOLID, 5, "Y Axis", '%d');
    $ochart->setLabels($vLabels, '#000000', 1, HORIZONTAL);
    $ochart->plot("./shots/$k.png");
    $vTime[$k] = microtime() - $iTime;
    
    $out = fopen("./_screenshots.php", "w");
    fwrite($out, '<font face="sans-serif" size=2 color="#00bb22">');
    fwrite($out, '<b>PanaChart Examples</b></font> - ');
    fwrite($out, '<a href="./index.php?SEC=source"><font face="sans-serif" size=2>');
    fwrite($out, 'Examples source code</font></a>');
    fwrite($out, '<table cellspacing=3 cellpadding=0 border=0>');
    for($i=0; $i<=$k; $i++){
        if($i%2 == 0){
            if($i>0){
                fwrite($out, "$sout\n");
                fwrite($out, "$stim\n");
            }
            $sout='<tr>'; $stim='<tr>';
        }
        $sout.='<td><img border=0 src="./shots/'.$i.'.png"></td>';
        $stim.='<td><font size=2>'.number_format($vTime[$i], 3, '.',',').' sec.</font></td>';
        if($i%2 == 1){
            $simg.='</tr>'; $stim.='</tr>';
        }                
    }
    fwrite($out, "$sout\n");
    fwrite($out, "$stim\n");
    
    fwrite($out, '</table>');
    fclose($out);
?>